<?php 

function cptui_register_my_cpts_procesos() {

	/**
	 * Post Type: Procesos.
	 */
	$labels = array(
		"name" => __( "Procesos", "houseProtect" ),
		"singular_name" => __( "Proceso", "houseProtect" ),
		"menu_name" => __( "Procesos", "houseProtect" ),
		"all_items" => __( "Todos los procesos", "houseProtect" ),
		"add_new" => __( "Agregar proceso", "houseProtect" ),
		"add_new_item" => __( "Añadir nuevo proceso", "houseProtect" ),
		"edit_item" => __( "Editar proceso", "houseProtect" ),
		"new_item" => __( "Nuevo proceso", "houseProtect" ),
		"view_item" => __( "Ver proceso", "houseProtect" ),
		"view_items" => __( "Ver proceso", "houseProtect" ),
		"search_items" => __( "Buscar proceso", "houseProtect" ),
		"not_found" => __( "No se encontró el proceso", "houseProtect" ),
		"not_found_in_trash" => __( "No se encontro en la papelera", "houseProtect" ),
		"featured_image" => __( "Imagen destacada", "houseProtect" ),
		"set_featured_image" => __( "Establecer imagen destacada", "houseProtect" ),
		"remove_featured_image" => __( "Remover imagen destacada", "houseProtect" ),
		"use_featured_image" => __( "Utilizar como imagen destacada", "houseProtect" ),
	);

	$args = array(
		"label" => __( "Procesos", "houseProtect" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"delete_with_user" => false,
		"show_in_rest" => false,
		"rest_base" => "",
		"rest_controller_class" => "WP_REST_Posts_Controller",
		"has_archive" => false,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "proceso", "with_front" => true ),
		"query_var" => true,
		"menu_icon" => "dashicons-format-aside",
		"supports" => array( "title", "thumbnail", "custom-fields", "author" ),
		"show_in_graphql" => true,
		"hierarchical" => true,
        "graphql_single_name" => "proceso",
		"graphql_plural_name" => "procesos",
	);

	register_post_type( "proceso", $args );
}

add_action( 'init', 'cptui_register_my_cpts_procesos' );





// Hook para agregar un metabox en el CPT "proceso"
function agregar_boton_documento_proceso() {
    add_meta_box(
        'boton_documento',            // ID del metabox
        'Ir al Documento',             // Título del metabox
        'mostrar_boton_documento',    // Función que muestra el contenido
        'proceso',                     // CPT al que se le agrega el metabox
        'side',                        // Ubicación del metabox (puede ser 'side', 'normal', 'advanced')
        'high'                         // Prioridad del metabox
    );
}
add_action('add_meta_boxes', 'agregar_boton_documento_proceso');

// Función que muestra el botón en el metabox
function mostrar_boton_documento($post) {
    // Obtener el ID del documento desde el campo ACF
    $documento_arrendador = get_field('documento_arrendador', $post->ID); // Cambia 'campo_documento' por el nombre del campo ACF
    $documento_arrendatario = get_field('documento_arrendatario', $post->ID); // Cambia 'campo_documento' por el nombre del campo ACF
    $documento_fiador = get_field('documento_fiador', $post->ID); // Cambia 'campo_documento' por el nombre del campo ACF
    $documento_obligado_solidario = get_field('documento_obligado_solidario', $post->ID); // Cambia 'campo_documento' por el nombre del campo ACF

	// Verificar si existe el documento asociado	
	$documento_arrendador_id = is_array($documento_arrendador) ? $documento_arrendador[0] : $documento_arrendador->ID;
	$documento_arrendatario_id = is_array($documento_arrendatario) ? $documento_arrendatario[0] : $documento_arrendatario->ID;
	$documento_fiador_id = is_array($documento_fiador) ? $documento_fiador[0] : $documento_fiador->ID;
	$documento_obligado_solidario_id = is_array($documento_obligado_solidario) ? $documento_obligado_solidario[0] : $documento_obligado_solidario->ID;

	if ($documento_arrendador_id) {
		// Crear la URL para editar el documento en el admin
		$documento_edit_url = admin_url().'post.php?post='.$documento_arrendador_id.'&action=edit';
		// Mostrar el botón para ir al documento en el admin
		echo '<a href="' . esc_url($documento_edit_url) . '" class="button" target="_blank">Editar Documento Arrendador</a><br/><br/>';
	} else {
		echo 'No hay documento arrendador.<br/><br/>';
	}


	// Verificar si existe el documento asociado

	if ($documento_arrendatario_id) {
		// Crear la URL para editar el documento en el admin
		$documento_edit_url = admin_url().'post.php?post='.$documento_arrendatario_id.'&action=edit';
		// Mostrar el botón para ir al documento en el admin
		echo '<a href="' . esc_url($documento_edit_url) . '" class="button" target="_blank">Editar Documento Arrendatario</a><br/><br/>';
	} else {
		echo 'No hay documento arrendatario.<br/><br/>';
	}

	// Verificar si existe el documento asociado
	if ($documento_fiador_id) {
		// Crear la URL para editar el documento en el admin
		$documento_edit_url = admin_url().'post.php?post='.$documento_fiador_id.'&action=edit';
		// Mostrar el botón para ir al documento en el admin
		echo '<a href="' . esc_url($documento_edit_url) . '" class="button" target="_blank">Editar Documento Fiador</a> <br/><br/>';
	} else {
		echo 'No hay documento fiador.<br/><br/>';
	}

    // Verificar si existe el documento asociado
    if ($documento_obligado_solidario_id) {
        // Crear la URL para editar el documento en el admin
        $documento_edit_url = admin_url().'post.php?post='.$documento_obligado_solidario_id.'&action=edit';
        // Mostrar el botón para ir al documento en el admin
        echo '<a href="' . esc_url($documento_edit_url) . '" class="button" target="_blank">Editar Documento Obligado solidario</a>';
    } else {
        echo 'No hay documento obligado solidario.';
    }
}



?>